#ifndef __CMouseEvent__
#define __CMouseEvent__

#include <Basics/CCountedObject.hpp>
#include "../Windowing/CMouse.hpp"

//	===========================================================================

using Exponent::Basics::CCountedObject;
using Exponent::GUI::Windowing::CMouse;

//	===========================================================================

#ifdef WIN32
	#ifndef WM_MOUSEWHEEL
	  #define WM_MOUSEWHEEL 0x020A
	#endif
#endif

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Events
		{
			/**
			 * @class CMouseEvent CMouseEvent.hpp
			 * @brief Allows for responding to mouse actions
			 *
			 * @date 21/08/2004
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CMouseEvent.hpp,v 1.4 2007/02/08 21:07:54 paul Exp $
			 */
			class CMouseEvent : public CCountedObject
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

	//	===========================================================================

				/**
				 * @enum EMouseEventType
				 * @brief Enumerated mouse movements
				 */
				enum EMouseEventType
				{
					#ifdef WIN32
						e_leftMouseDown			= WM_LBUTTONDOWN,			/**< Left button down */
						e_rightMouseDown		= WM_RBUTTONDOWN,			/**< Right button down */
						e_leftMouseUp			= WM_LBUTTONUP,				/**< Left button up */
						e_rightMouseUp			= WM_RBUTTONUP,				/**< Right button up */
						e_leftMouseDoubleClick	= WM_LBUTTONDBLCLK,			/**< Double click */
						e_button3MouseClick		= 0,						/**< Wheel click */
						e_mouseWheelMove		= WM_MOUSEWHEEL,			/**< Wheel */
						e_mouseMove				= WM_MOUSEMOVE,				/**< Movement */
						e_mouseLeftArea			= WM_MOUSELEAVE				/**< Mosue left user area */
					#else
						e_leftMouseDown = 0,								/**< Left button down */
						e_rightMouseDown,									/**< Right button down */
						e_leftMouseUp,										/**< Left button up */
						e_rightMouseUp,										/**< Right button up */
						e_leftMouseDoubleClick,								/**< Double click */
						e_button3MouseClick,								/**< Wheel click */
						e_mouseWheelMove,									/**< Wheel */
						e_mouseMove,										/**< Movement */
						e_mouseLeftArea,									/**< Mosue left user area */
					#endif
				};

	//	===========================================================================

				/**
				 * Construction
				 * @param mouse The mouse
				 * @param type The type of event
				 * @param wheelMovementAmount The amount of wheel movement -1 -> +1
				 */
				CMouseEvent(CMouse *mouse, const EMouseEventType type, double wheelMovementAmount = 0.0);

				#ifdef WIN32
					/**
					 * Construction
					 * @param mouse The mouse
					 * @param type The type of event
					 * @param wheelMovementAmount The amount of wheel movement -1 -> +1
					 */
					CMouseEvent(CMouse *mouse, const UINT type, double wheelMovementAmount = 0.0);
				#endif

				/**
				 * Destruction
				 */
				virtual ~CMouseEvent();

	//	===========================================================================

				/**
				 * Set the wheel movement amount
				 * @param wheelMovementAmount The amount of movement -1 -> +1
				 */
				void setWheelMovementAmount(const double wheelMovementAmount);

				/**
				 * Get the wheel movement amount
				 * @retval double The mouse wheel movement amount -1 -> +1
				 */
				double getWheelMovementAmount() const;

	//	===========================================================================

				/**
				 * Set the event type
				 * @param type The mouse event type
				 */
				void setEventType(EMouseEventType type);

				/**
				 * Get the event type
				 * @retval EMouseEventType The type of event
				 */
				EMouseEventType getEventType() const;

	//	===========================================================================

				/**
				 * Get the mouse
				 * @retval const CMouse* The mouse
				 */
				const CMouse *getMouse() const;

				/**
				 * Get the mouse
				 * @retval CMouse* The mouse
				 */
				CMouse *getMutableMouse() const;

	//	===========================================================================

				/**
				 * Set the modifiers
				 * @param shift True if shift is down, false otherwise
				 * @param alt True if alt is down, false otherwise
				 * @param ctrl True if ctrl is down, false otherwise
				 */
				void setModifiers(const bool ctrl, const bool shift, const bool alt);

				#ifdef WIN32
					/**
					 * Set the modifiers
					 * @param wParam The windows mouse raw parameters
					 */
					void setModifiers(WPARAM wParam);

					/**
					 * Get hte modifiers
					 * @retval WPARAM The mouse modifiers
					 */
					WPARAM getModifiers() const;
				#endif

	//	===========================================================================

				/**
				 * Is ctrl down
				 * @retval bool True if ctrl is down, false otherwise
				 */
				bool isCtrlDown() const;

				/**
				 * Is shift down
				 * @retval bool True if shift is down, false otherwise
				 */
				bool isShiftDown() const;

				/**
				 * Is the alt key down
				 * @retval bool True if alt is down, false otherwise
				 */
				bool isAltDown() const;

	//	===========================================================================

				/**
				 * Set the mouse postiion
				 * @param point The mouse position
				 */
				void setMousePosition(const CPoint &point);

				/**
				 * Get the mouse position
				 * @retval const CPoint The position of the mouse
				 */
				const CPoint &getMousePosition() const;

	//	===========================================================================

			protected:

	//	===========================================================================

				EMouseEventType m_type;						/**< The type of event */
				CMouse *m_mouse;							/**< The mouse that generated this */
				double m_wheelMovementAmount;				/**< The mouse wheel movement amount */

				bool m_ctrlIsDown;							/**< Is ctrl key down */
				bool m_shiftIsDown;							/**< Is shift key down */
				bool m_altIsDown;							/**< Is alt key down */

				#ifdef WIN32
					WPARAM m_rawModifiers;					/**< Raw modifiers for internal use */
				#endif

			};
		}
	}
}
#endif	// End of CMouseEvent.hpp